using BlazorApp1.Data;
using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using Syncfusion.Blazor;

var builder = WebApplication.CreateBuilder(args);

// Add services to the container.
builder.Services.AddRazorPages();
builder.Services.AddServerSideBlazor();
builder.Services.AddSyncfusionBlazor();
builder.Services.AddSingleton<WeatherForecastService>();

var app = builder.Build();

//Register Syncfusion license
Syncfusion.Licensing.SyncfusionLicenseProvider.RegisterLicense("Mgo+DSMBaFt+QHJqVk1mQ1NAaV1CX2BZeVl1QWlYf04BCV5EYF5SRHNdR11kSnhTdUJjWHw=;Mgo+DSMBPh8sVXJ1S0R+X1pCaV1GQmFJfFBmQmlae1RxdEU3HVdTRHRcQlhhTH5UdUNjWnhfdnc=;ORg4AjUWIQA/Gnt2VFhiQlJPcEBAWXxLflF1VWRTfFp6dVVWESFaRnZdQV1mS3tTcUZlWXxZc3ZW;MjE5NDEyOEAzMjMxMmUzMjJlMzNPSW9CRzFjQm9LYVdTMk9EL0N4SFFFdkxid2lPVjlhbk9xcE1Na1pmSG5FPQ==;MjE5NDEyOUAzMjMxMmUzMjJlMzNXcnIrNU0vRlhYeUV0VllHR0Fiam1DNGZZRDBJMnRiQUNaOGNWd1R3Zm5vPQ==;NRAiBiAaIQQuGjN/V0d+Xk9HfVldX2dWfFN0RnNedV10flRGcC0sT3RfQF5jTHxWdkJgX39dd31dRQ==;MjE5NDEzMUAzMjMxMmUzMjJlMzNQMlVPREFLektSTHFsZXpyL09lUnJaZXIrc3R6MW9Ka09laWRzK0tLTUc4PQ==;MjE5NDEzMkAzMjMxMmUzMjJlMzNSTEg4QmxjSWtsdGdna09YOFRrTzdBaStmOFRyTktKVjU2d2hOdlZza1pVPQ==;Mgo+DSMBMAY9C3t2VFhiQlJPcEBAWXxLflF1VWRTfFp6dVVWESFaRnZdQV1mS3tTcUZlWXxWd3BW;MjE5NDEzNEAzMjMxMmUzMjJlMzNuaDZ3WVU0NFBzU0VoWXdsZWoyQm44NmhKUTVFRm04RjZma0N6aW9rM3gwPQ==;MjE5NDEzNUAzMjMxMmUzMjJlMzNkdGdqS1hEdnhsRUprRHE4Sno5MEI4VVc1RDlyRHZRb3kxRE90eVFoNGY0PQ==;MjE5NDEzNkAzMjMxMmUzMjJlMzNQMlVPREFLektSTHFsZXpyL09lUnJaZXIrc3R6MW9Ka09laWRzK0tLTUc4PQ==");

// Configure the HTTP request pipeline.
if (!app.Environment.IsDevelopment())
{
    app.UseExceptionHandler("/Error");
    // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
    app.UseHsts();
}

app.UseHttpsRedirection();

app.UseStaticFiles();

app.UseRouting();

app.MapBlazorHub();
app.MapFallbackToPage("/_Host");

app.Run();
